function syncField(nid, fieldName, fieldId)
{
    $button = jQuery('#button-' + fieldId);
    $throbber = jQuery('#throbber-' + fieldId);
    
    $button.hide();
    $throbber.show();
    
    $throbber.show();
    
    //-- prépare les données à envoyer au serveur
    $data = {
        'nid':nid,
        'fieldName':fieldName
    };
    
    //-- envoie la requête en AJAX
    jQuery.ajax(
    {
        url:'http://cot.studiosherpa.com/admin/config/webservice_nodes/synchronisation/ajax_field_sync',
        type:'POST',
        data:$data,
        dataType:'json',
        
        //-- les données renvoyées sont réinjectées dans le champ
        success:function(jsonData)
        {
            jQuery('#' + fieldId).val(jsonData.data);
            
            $button.show();
            $throbber.hide();
        },
        
        //-- en cas d'erreur, on affiche une alerte JS
        error:function(err)
        {
            alert('La synchronisation a échouée (erreur dans la console).');
            if (!!window.console) console.log(err);
            
            $button.show();
            $throbber.hide();
        }
    });
    
    return false;
}